from __future__ import generators
import plus
import Arenas
import random
import Hazards
import math
import DSLHaz

class BoxArena(Arenas.SuperArena):
    "DSL Drum Of Death Arena, an old zero gravity simulator donated by NASA and modified into an arena, don't fly up too high!"
    name = "DSL Drum Of Death Arena"
    preview = "DSLDrumArena/DSLDrum_preview.bmp"
    game_types = ['DEATHMATCH', 'BATTLE ROYAL', 'TEAM MATCH']
    extent = (-16, 16, 16, -16)

    def __init__(self):
        Arenas.SuperArena.__init__(self, "Arenas/DSLDrumArena/DSLDrum.gmf")
        #plus.Arena.__init__(self, "")
        plus.setBackColor(0,0,0)
        fmod = 0.015
        degrad = 0.01745
        self.AddStaticCamera("              Static-1", (0, 45, 0), (90*degrad, 0), degrad*65)
        self.AddStaticCamera("              Static-2", (0, 30, 0), (90*degrad, 90*degrad), degrad*80)
        self.AddStaticCamera("              Static-3 UP!", (0, 4, 0), (-90*degrad, 90*degrad), degrad*140)

        self.AddWatchCamera("               WatchCam-1a", (-20, 15, 0), (16, 20, 70*degrad, 40*degrad))
        self.AddWatchCamera("               WatchCam-1b", (-20, 25, 0), (16, 20, 70*degrad, 40*degrad))

        self.AddWatchCamera("               WatchCam-2a", (20, 15, 0), (16, 20, 70*degrad, 40*degrad))
        self.AddWatchCamera("               WatchCam-2b", (20, 25, 0), (16, 20, 70*degrad, 40*degrad))

        self.AddWatchCamera("               WatchCam-3a", (0, 10, 0), (16, 24, 50*degrad, 40*degrad))
        self.AddWatchCamera("               WatchCam-3b", (0, 20, 0), (16, 24, 50*degrad, 40*degrad))
	
        self.players = ()
        self.robone = 0
        self.robtwo = 0
        self.robtre = 0
        self.robfor = 0

    def __del__(self):
        if self.bHazardsOn:
            plus.removeSound(self.ambience)
        elif self.endmusic:
            plus.stopSound(self.endmusic)
            plus.removeSound(self.endmusic)
        Arenas.SuperArena.__del__(self)
        
    def AddShadowReceivers(self):
        self.SetShadowSource(5.897, 19.159, 5.899)
        
        #Main Arena Floor Shadow Triangles
        self.AddShadowTriangle((-10.2877,0.051,1.83754), (-12.4182,0.051,12.4283), (-12.4182,0.051,1.83754))
        self.AddShadowTriangle((-8.17686,0.051,9.91855), (-8.17686,0.051,12.4283), (-12.4182,0.051,12.4283))
        self.AddShadowTriangle((-8.17686,0.051,9.91855), (-12.4182,0.051,12.4283), (-10.2877,0.051,1.83754))
        self.AddShadowTriangle((2.25999,0.051,12.4283), (-2.49123,0.051,12.4283), (-2.49123,0.051,9.91855))
        self.AddShadowTriangle((2.25999,0.051,9.91855), (2.25999,0.051,12.4283), (-2.49123,0.051,9.91855))
        self.AddShadowTriangle((12.413,0.051,12.4283), (7.93297,0.051,12.4283), (7.93297,0.051,9.91855))
        self.AddShadowTriangle((10.2878,0.051,1.91641), (12.413,0.051,12.4283), (7.93297,0.051,9.91855))
        self.AddShadowTriangle((10.2878,0.051,1.91641), (12.413,0.051,1.91641), (12.413,0.051,12.4283))
        self.AddShadowTriangle((8.17711,0.051,-9.92447), (12.413,0.051,-12.4279), (10.2878,0.051,-1.93329))
        self.AddShadowTriangle((10.2878,0.051,-1.93329), (12.413,0.051,-12.4279), (12.413,0.051,-1.93329))
        self.AddShadowTriangle((8.17711,0.051,-9.92447), (8.17711,0.051,-12.4279), (12.413,0.051,-12.4279))
        self.AddShadowTriangle((-2.26871,0.051,-12.4279), (2.49519,0.051,-12.4279), (2.49519,0.051,-9.92447))
        self.AddShadowTriangle((-2.26871,0.051,-9.92447), (-2.26871,0.051,-12.4279), (2.49519,0.051,-9.92447))
        self.AddShadowTriangle((-12.4182,0.051,-12.4279), (-7.93688,0.051,-12.4279), (-7.93688,0.051,-9.92447))
        self.AddShadowTriangle((-10.2877,0.051,-1.8361), (-12.4182,0.051,-12.4279), (-7.93688,0.051,-9.92447))
        self.AddShadowTriangle((-10.2877,0.051,-1.8361), (-12.4182,0.051,-1.8361), (-12.4182,0.051,-12.4279))
        self.AddShadowTriangle((-2.49123,0.051,9.91855), (-8.17686,0.051,9.91855), (-10.2877,0.051,1.83754))
        self.AddShadowTriangle((2.49519,0.051,-9.92447), (8.17711,0.051,-9.92447), (10.2878,0.051,-1.93329))
        self.AddShadowTriangle((10.2878,0.051,-1.93329), (-10.2877,0.051,-1.8361), (-2.26871,0.051,-9.92447))
        self.AddShadowTriangle((10.2878,0.051,1.91641), (7.93297,0.051,9.91855), (2.25999,0.051,9.91855))
        self.AddShadowTriangle((2.25999,0.051,9.91855), (-2.49123,0.051,9.91855), (-10.2877,0.051,1.83754))
        self.AddShadowTriangle((10.2878,0.051,1.91641), (2.25999,0.051,9.91855), (-10.2877,0.051,1.83754))
        self.AddShadowTriangle((10.2878,0.051,-1.93329), (10.2878,0.051,1.91641), (-10.2877,0.051,1.83754))
        self.AddShadowTriangle((-10.2877,0.051,-1.8361), (10.2878,0.051,-1.93329), (-10.2877,0.051,1.83754))
        self.AddShadowTriangle((-2.26871,0.051,-9.92447), (2.49519,0.051,-9.92447), (10.2878,0.051,-1.93329))
        self.AddShadowTriangle((-10.2877,0.051,-1.8361), (-7.93688,0.051,-9.92447), (-2.26871,0.051,-9.92447))
        
    def HazardsOn(self, on):
        if on:
            self.AddCollisionLine((0, 10), (5, 10))
            self.AddCollisionLine((5, 9), (9, 5))
            self.AddCollisionLine((9, 5), (10, 0))
            self.AddCollisionLine((10, 0), (9, -5))
            self.AddCollisionLine((9, -5), (5, -9))
            self.AddCollisionLine((5, -9), (0, -10))
            self.AddCollisionLine((0, -10), (-5, -9))
            self.AddCollisionLine((-5, -9), (-9, -5))
            self.AddCollisionLine((-9, -5), (-10, 0))
            self.AddCollisionLine((-10, 0), (-9, 5))
            self.AddCollisionLine((-9, 5), (-5, 9))
            self.AddCollisionLine((-5, 9), (0, 10))
            
            self.AddPOV(0, (0, 12), (1, 7))
            self.AddPOV(1, (10, 10), (2, 0))
            self.AddPOV(2, (12, 0), (3, 1))
            self.AddPOV(3, (10, -10), (4, 2))
            self.AddPOV(4, (0, -12), (5, 3))
            self.AddPOV(5, (-10, -10), (6, 4))
            self.AddPOV(6, (-12, 0), (7, 5))
            self.AddPOV(7, (-10, 10), (0, 6))

            self.ambience = plus.createSound("Sounds/spinnerspin.wav", False, (0, 0, 0))
            plus.loopSound(self.ambience)
            self.SetSubMaterialSound("topprop", "metal", 0.6, "Sounds\\spinnerhit.wav")
            hinge = self.GetHinge("Hinge01")
            self.spinblade1 = DSLHaz.Blade(hinge, (0, 33, 0))
            self.AddHazard(self.spinblade1)
            hinge = self.GetHinge("Hinge02")
            self.spinblade2 = DSLHaz.Blade(hinge, (0, 0, 0))
            self.AddHazard(self.spinblade2)
            self.RegisterZone("flyzone", 1)



        return Arenas.SuperArena.HazardsOn(self, on)


    def ZoneEvent(self, direction, id, robot, chassis):

        if robot==1:
            if direction==1:
                self.robone=1
            elif direction==-1:
                self.robone=0
                
        elif robot==2:
            if direction==1:
                self.robtwo=1
            elif direction==-1:
                self.robtwo=0

        elif robot==3:
            if direction==1:
                self.robtre=1
            elif direction==-1:
                self.robtre=0

        elif robot==4:
            if direction==1:
                self.robfor=1
            elif direction==-1:
                self.robfor=0

        return True

    def Activate(self, on):
        if on: self.players = plus.getPlayers()
        
        Arenas.SuperArena.Activate(self, on)

    def Tick(self):
        if self.bHazardsOn:
            self.spinblade1.Spin()
            self.spinblade2.Spin()
        if self.robone==1:
            plus.force(0, 0, 240 * plus.getWeight(0), 0)
        if self.robtwo==1:
            plus.force(1, 0, 240 * plus.getWeight(1), 0)
        if self.robtre==1:
            plus.force(2, 0, 240 * plus.getWeight(2), 0)
        if self.robfor==1:
            plus.force(3, 0, 240 * plus.getWeight(3), 0)
	

        return Arenas.SuperArena.Tick(self)
        
Arenas.register(BoxArena)
